#!/usr/bin/perl

# CallerIDpop_libnotify v. 0.92 - polls Linksys/Sipura VoIP adapters once per
# second and issues a Notify popup on incoming calls.  Execute the script with
# the --help option to see all available options. If you make any modifications
# or improvements PLEASE send them to michigantelephone #<_a_t_># gmail.com or
# leave a comment on my blog at http://michigantelephone.wordpress.com/ for
# possible inclusion in future updates.

# Note that the script as written requires the presence of the callerid_pop.png
# file in the same directory as the script.  In addition there is an incomplete
# instructions.txt bundled with the script.  This script requires the following
# Perl modules to be installed on the user's system: Config::Simple (only if
# cfgpath option is used), Getopt::Long and LWP::Simple. Also libnotify must be
# installed.

# Copyright 2008 by Jack

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

# Turn on perl's safety features

use strict;
use warnings;

# Load some modules

use Getopt::Long;
use LWP::Simple qw($ua get);
use Config::Simple ('-lc');

# Try to get directory path in which script is running

$0 =~ /^(.+[\\\/])[^\\\/]+[\\\/]*$/;
my $scriptdir = $1 || "./";

# Set up some defaults

my $iconpath = $scriptdir . 'callerid_pop.png';
my $addrpath = $scriptdir . 'adapterip';
my $display  = 0;
my $devfound = 0;
my $result   = 0;
my $lowip    = 2;
my $highip   = 254;
my $netbase  = '192.168.0.';
my $timeout  = 0;

# Get command line arguments

my (
    $document, $na,       $nocw,    $mac,   $ipaddr,
    $cfgpath,  $namepath, $picpath, $cqlog, $plainlog
);
my @lineid = (
    "Line 1",
    "Line 1 (Call Waiting)",
    "Line 2",
    "Line 2 (Call Waiting)",
    "Line 3",
    "Line 3 (Call Waiting)",
    "Line 4",
    "Line 4 (Call Waiting)",
    "Line 5",
    "Line 5 (Call Waiting)",
    "Line 6",
    "Line 6 (Call Waiting)",
    "Line 7",
    "Line 7 (Call Waiting)",
    "Line 8",
    "Line 8 (Call Waiting)"
);

GetOptions(
    'help'       => \$document,
    'na'         => \$na,
    'nocw'       => \$nocw,
    'mac=s'      => \$mac,
    'ipaddr=s'   => \$ipaddr,
    'lowip=s'    => \$lowip,
    'highip=s'   => \$highip,
    'netbase=s'  => \$netbase,
    'saveip=s'   => \$addrpath,
    'namepath=s' => \$namepath,
    'picpath=s'  => \$picpath,
    'cfgpath=s'  => \$cfgpath,
    'iconpath=s' => \$iconpath,
    'display=s'  => \$display,
    'cqlog=s'    => \$cqlog,
    'plainlog=s' => \$plainlog,
    'line1id=s'  => \$lineid[0],
    'line1cw=s'  => \$lineid[1],
    'line2id=s'  => \$lineid[2],
    'line2cw=s'  => \$lineid[3],
    'line3id=s'  => \$lineid[4],
    'line3cw=s'  => \$lineid[5],
    'line4id=s'  => \$lineid[6],
    'line4cw=s'  => \$lineid[7],
    'line5id=s'  => \$lineid[8],
    'line5cw=s'  => \$lineid[9],
    'line6id=s'  => \$lineid[10],
    'line6cw=s'  => \$lineid[11],
    'line7id=s'  => \$lineid[12],
    'line7cw=s'  => \$lineid[13],
    'line8id=s'  => \$lineid[14],
    'line8cw=s'  => \$lineid[15],
    'timeout=s'  => \$timeout
);

# Print essential info

print
"\nCallerIDpop_libnotify v0.92\nCopyright (C) 2008 by Jack\nThis program comes with ABSOLUTELY NO WARRANTY; for details or additional help\nuse the --help option. This is free software, and you are welcome to\nredistribute it under certain conditions; see the accompanying Instructions.txt\nfile and/or the GNU Public License at http://www.gnu.org/licenses/ for details.\n\n";

# If user requested help then print it and exit

if ($document) {
    print << "EOF" ;

Usage:   $0 [options]

Available command line options are shown below. Defaults are shown in <angle
     brackets>. DO NOT USE THE ANGLE BRACKETS WHEN SPECIFYING REAL OPTIONS!!!:

--mac=<macaddress> where <macaddress> is in form 123456ABCDEF (12 character MAC
     address string, which may be found on the adapter's web page)

--ipaddr=<ip address> where <ip address> is the FIXED ip address of an adapter
     (do NOT use if device uses DHCP to get an address!!!)

IMPORTANT: You MUST specify EITHER a MAC address or an IP address using one
     (and ONLY one) of the above options (either here or in config file)!

--cfgpath= (no default) use this option to specify FULL PATH and filename of
     config file in place of most command line options - see documentation file   

NOTE: The next four options are only recognized when using --mac option
     (defaults are shown within angle brackets):

--netbase=<192.168.0.> you may specify first three octets of the ip address
     range to search for the adapter (include the trailing period!)

--lowip=<2> low final octet of ip address to search for adapter

--highip=<254> high final octet of ip address to search for adapter (max. 255)

--saveip=<{script home directory}/adapterip> path and filename to a file in
     which will be saved current adapter ip address between runs. This address
     will be tried first on the next run of the program, prior to searching the
     IP range for the the MAC address
     Example usage:  --saveip=/Users/username/Applications/CallerIDpop/adapterip
     Device's MAC address will be appended to specified filename by script

ADDITIONAL OPTIONS:

--iconpath=<{script home directory}/callerid_pop.png> path and filename to a
     .png file used with notification display (max size 200x100)

--line1id=<\"Line 1\">                    these specify ID text that appears in
--line1cw=<\"Line 1 (Call Waiting)\">     notification when specified
--line2id=<\"Line 2\">                    line/channel is ringing - may specify
--line2cw=<\"Line 2 (Call Waiting)\">     normal & CW ID's for lines 1 - 8 (to
     device maximum) using this format. DO NOT USE ANGLE BRACKETS OR AMPERSANDS.

--display=1 use number instead of name in top title line
--display=2 use \"name - number\" format in top title line
--display=3 use \"number - name\" format in top title line
     Note: If --display not used, default is name only in top title line

--na  (no options) includes hyphens in numbers that appear to be from U.S.A./
     Canada/other NANP locations (examples: 800-555-1212 or 1-800-555-1212)

--nocw  (no options) use this switch if device doesn't support call waiting
     (if used, linexcw options will be ignored)

--timeout=<0> optional time limit for notifications to stay on screen

--namepath= (no default) FULL PATH and filename of a plain text file containing
     Caller ID numbers followed by name substitutions.  Number must be exactly
     as received from provider. Name may not contain commas or certain other
     special characters unless enclosed in quotation marks. Example line:
     2484345508 "Rolled, Rick"
     
--picpath= (no default) FULL PATH and filename of a plain text file containing
     Caller ID numbers followed by FULL PATH and filename of image files to be
     used as icons when calls from those numbers are received. Number must be
     exactly as received from provider. Note that the --picpath argument MUST
     point to a TEXT FILE in the proper format, NOT TO AN IMAGE FILE!!!!!
     Example line in text file:
     2484345508 /Users/username/Pictures/Rick.jpg
     It is the user\'s responsibility to make sure that all referenced image
     files are in a format that is acceptable for the notification program!

--plainlog= (no default) FULL PATH and filename of a human-readable log file

--cqlog= (no default) FULL PATH and filename of a comma-quote delimited log
     file.  Format is: year,month,day,hour,minute,second,is_dst(1=true),
     caller_name,caller_number,line_id,disposition (one line per call received).
     All date/time values are numeric, other fields are strings.

--help  (no options) prints this help message (use --help | less to page)

NOTE: There is NO ERROR CHECKING on most entered values, if you enter them
incorrectly the results are unpredictable!!! Do NOT include the angle brackets
when entering values, but BE SURE TO USE QUOTATION MARKS (\") around values that
include spaces (particularly the linexid and linexcw values).

IMPORTANT: THERE IS NO WARRANTY FOR THE PROGRAM. THE COPYRIGHT HOLDERS AND/OR
OTHER PARTIES PROVIDE THE PROGRAM \"AS IS\" WITHOUT WARRANTY OF ANY KIND, EITHER
EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE ENTIRE RISK AS TO THE
QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU. SHOULD THE PROGRAM PROVE
DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
EOF
    print "\n\n";
    exit;
}

# Set user agent and initial timeout (experimental)
$ua->agent('CallerIDpop/0.92');
$ua->timeout(30);

# If a configuration file was specified then open and get arguments

if ($cfgpath) {
    my $cfg = new Config::Simple($cfgpath)
      or die
"Could not find configuration file $cfgpath\nmake sure it exists and is in correct format, or don't use --cfgpath option!\n\n";
    print
"Using configuration file $cfgpath\nWarning: Configuration file option takes precedence over command line\n     option when same option is specified in both places!\n";
    if ( $cfg->param('na') )       { $na         = 1 }
    if ( $cfg->param('nocw') )     { $nocw       = 1 }
    if ( $cfg->param('mac') )      { $mac        = $cfg->param('mac') }
    if ( $cfg->param('ipaddr') )   { $ipaddr     = $cfg->param('ipaddr') }
    if ( $cfg->param('lowip') )    { $lowip      = $cfg->param('lowip') }
    if ( $cfg->param('highip') )   { $highip     = $cfg->param('highip') }
    if ( $cfg->param('netbase') )  { $netbase    = $cfg->param('netbase') }
    if ( $cfg->param('saveip') )   { $addrpath   = $cfg->param('saveip') }
    if ( $cfg->param('iconpath') ) { $iconpath   = $cfg->param('iconpath') }
    if ( $cfg->param('namepath') ) { $namepath   = $cfg->param('namepath') }
    if ( $cfg->param('picpath') )  { $picpath    = $cfg->param('picpath') }
    if ( $cfg->param('display') )  { $display    = $cfg->param('display') }
    if ( $cfg->param('cqlog') )    { $cqlog      = $cfg->param('cqlog') }
    if ( $cfg->param('plainlog') ) { $plainlog   = $cfg->param('plainlog') }
    if ( $cfg->param('line1id') )  { $lineid[0]  = $cfg->param('line1id') }
    if ( $cfg->param('line1cw') )  { $lineid[1]  = $cfg->param('line1cw') }
    if ( $cfg->param('line2id') )  { $lineid[2]  = $cfg->param('line2id') }
    if ( $cfg->param('line2cw') )  { $lineid[3]  = $cfg->param('line2cw') }
    if ( $cfg->param('line3id') )  { $lineid[4]  = $cfg->param('line3id') }
    if ( $cfg->param('line3cw') )  { $lineid[5]  = $cfg->param('line3cw') }
    if ( $cfg->param('line4id') )  { $lineid[6]  = $cfg->param('line4id') }
    if ( $cfg->param('line4cw') )  { $lineid[7]  = $cfg->param('line4cw') }
    if ( $cfg->param('line5id') )  { $lineid[8]  = $cfg->param('line5id') }
    if ( $cfg->param('line5cw') )  { $lineid[9]  = $cfg->param('line5cw') }
    if ( $cfg->param('line6id') )  { $lineid[10] = $cfg->param('line6id') }
    if ( $cfg->param('line6cw') )  { $lineid[11] = $cfg->param('line6cw') }
    if ( $cfg->param('line7id') )  { $lineid[12] = $cfg->param('line7id') }
    if ( $cfg->param('line7cw') )  { $lineid[13] = $cfg->param('line7cw') }
    if ( $cfg->param('line8id') )  { $lineid[14] = $cfg->param('line8id') }
    if ( $cfg->param('line8cw') )  { $lineid[15] = $cfg->param('line8cw') }
    if ( $cfg->param('timeout') )  { $timeout    = $cfg->param('timeout') }
}

# If neither MAC address nor fixed IP address given then tell user and exit

if ( not $mac and not $ipaddr ) {
    print
"\nEither a mac address or an ip address (not both) must be specified\nspecify a mac address (only) unless adapter is at fixed IP address.\nUse --help to see all possible options\n\n";
    exit;
}

# If using fixed IP then tell user and convert to URL

elsif ($ipaddr) {
    print "Using fixed ip address: $ipaddr\n";
    $ipaddr   = 'http://' . $ipaddr . '/';
    $document = $ipaddr;
}

# If using MAC address then tell user and search for adapter on subnet

elsif ($mac) {
    print "Using MAC address: $mac\n";
    if ( $mac =~ /^[\dA-F]{12}$/ ) {
        $addrpath = $addrpath . "." . $mac;
        $mac      = ">" . $mac . "<";

        # First try the last known address if user specified a save file

        if ($addrpath) {
            if ( open( FILE, $addrpath ) ) {
                $ipaddr = <FILE>;
                close FILE;
                $document = get $ipaddr;
                if ($document) {
                    $result = index( $document, $mac );
                    if ( $result > 0 ) {
                        $devfound = 1;
                    }
                }
            }
        }
    }
    else {
        print
"\nMAC address is not in correct format - must be 12 characters in range 0-9 and A-F\ntry copying it from your device's web interface and pasting it into the cammand line.\n\n";
        exit;
    }

    # Find the specific adapter on the subnet

    if ( $devfound == 0 ) {
        for ( my $count = $lowip ; $count <= $highip ; $count++ ) {
            $ipaddr   = 'http://' . $netbase . $count . '/';
            $document = get $ipaddr;
            if ($document) {
                $result = index( $document, $mac );
                if ( $result > 0 ) {
                    $devfound = 1;
                    $count    = $highip;
                }
            }
        }
    }

    # If device IP was found then try to save it for future run

    if ( $devfound == 1 ) {
        if ($addrpath) {

            if ( open( FILE, ">$addrpath" ) ) {
                print FILE $ipaddr;
                close FILE;
            }
        }

    }

    # If device IP was NOT found then print the sad news and exit

    else {
        print "\nUnable to find adapter on subnet $netbase\n\n";
        exit;
    }
}

# This code runs only if device has been found

# This is where Notify registration would go if we weren't winging it with the command line

# Initialize some variables

my ( $stat, @logp, @logcq );
my @flag = ( 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 );
my @months = (
    "January", "February", "March",     "April",   "May",      "June",
    "July",    "August",   "September", "October", "November", "December"
);
my @weekdays = (
    "Sunday",   "Monday", "Tuesday", "Wednesday",
    "Thursday", "Friday", "Saturday"
);

# If no call waiting channels then rearrange array

if ($nocw) {
    for ( my $count = 1 ; $count <= 8 ; $count++ ) {
        $lineid[$count] = $lineid[ $count * 2 ];
    }
}

# Pre-define regular expressions to get line status, caller name and caller number

my $regex1 = qr/(?:Call|Line) [1-8]?[ ]?State:[^>]+>[^>]+>\s*(.+?)\s*</;
my $regex2 = qr/Peer Name:[^>]+>[^>]+>\s*(.*?)\s*</;
my $regex3 = qr/Peer Phone:[^>]+>[^>]+>\s*(.*?)\s*</;

# If doing number-name substitutions preload file

undef my $cfg;
if ($namepath) { $cfg = new Config::Simple($namepath) }
undef my $pic;
if ($picpath) { $pic = new Config::Simple($picpath) }

# Set timeout for page gets to 3 seconds (experimental)

$ua->timeout(3);

# BELOW THIS LINE IS THE LOOP THAT RUNS CONTINUOUSLY

# Begin loop - sleep 1 second

while ($document) {

    sleep 1;
    undef $document;

    # Get the source code of the page
    eval { $document = get $ipaddr};
    warn() if $@;

# If read failed sleep 2 seconds and try again (adapter may be updating configuration)

    until ($document) {
        sleep 2;
        eval { $document = get $ipaddr};
        warn() if $@;
    }

    # Get line status indications into array

    my @status = $document =~ /$regex1/g;

    # Step through lines, if a line is noticed as ringing send notification

    my $count = 0;
    foreach $stat (@status) {
        if ( $stat eq "Ringing" ) {
            if ( $flag[$count] == 0 ) {

# If we get here a line has just gone into ringing status
# Get name and phone data into array - this is only wasteful if multiple lines start ringing simultaneously

                my @name  = $document =~ /$regex2/g;
                my @phone = $document =~ /$regex3/g;

                # Get date for notification and put into human-friendly format

                my (
                    $sec,  $min,  $hour, $mday, $mon,
                    $year, $wday, $yday, $isdst
                ) = localtime(time);
                my $ampm     = "AM";
                my $datahour = $hour;
                if ( $hour eq 12 ) { $ampm = "PM"; }
                if ( $hour eq 0 )  { $hour = "12"; }
                if ( $hour > 12 ) {
                    $ampm = "PM";
                    $hour = ( $hour - 12 );
                }
                if ( $min < 10 ) { $min = "0" . $min; }
                $year += 1900;
                my $fulldate =
"$hour:$min $ampm on $weekdays[$wday], $months[$mon] $mday, $year";

                undef my $displayname;
                undef my $displayicon;

                # Check if phone number received

                my $phonenum = $phone[$count];
                if ( $phonenum ne "" ) {

                    # Check for matching number for name or icon substitution

                    if ($cfg) {
                        eval { $displayname = $cfg->param($phonenum) };
                    }

                    if ($pic) {
                        eval { $displayicon = $pic->param($phonenum) };
                    }
                    if ( !$displayicon ) { $displayicon = $iconpath }

     # If number appears to be NANP number and --na option set then normalize it

                    if ($na) {
                        $phonenum =~
                          s/^([2-9])(\d{2})([2-9])(\d{2})(\d{4})$/$1$2-$3$4-$5/;
                        $phonenum =~
s/^(1)([2-9])(\d{2})([2-9])(\d{2})(\d{4})$/$1-$2$3-$4$5-$6/;
                    }
                }
                else {
                    $phonenum = 'Number Not Available';
                }

                # Remove quote marks and whitespace around name, if any,
                # change &amp; to &, and indicate if name was not sent

                if ( !$displayname ) {
                    $displayname = $name[$count];
                    $displayname =~ s/^\s*"|"\s*$//g;
                    $displayname =~ s/^\s+|\s+$//g;
                    $displayname =~ s/&amp;/&/g;
                    if ( $displayname eq "" ) {
                        $displayname = 'Name Not Available';
                    }
                }

                # Prepare partial strings for log output if requested

                if ($plainlog) {
                    $logp[$count] =
"$phonenum ($displayname) called $lineid[$count] at $fulldate (";
                }
                if ($cqlog) {
                    $mon++;
                    $logcq[$count] =
"\"$year\",\"$mon\",\"$mday\",\"$datahour\",\"$min\",\"$sec\",\"$isdst\",\"$displayname\",\"$phonenum\",\"$lineid[$count]\",\"";
                }

                # Make output string in chosen format

                if ( $display eq 1 ) {
                    $displayname =
"notify-send -u critical -i \"$displayicon\" -t $timeout \"$phonenum\" \"$displayname\nfor $lineid[$count]\n$fulldate\"";
                }
                elsif ( $display eq 2 ) {
                    $displayname =
"notify-send -u critical -i \"$displayicon\" -t $timeout \"$displayname - $phonenum\" \"for $lineid[$count]\n$fulldate\"";
                }
                elsif ( $display eq 3 ) {
                    $displayname =
"notify-send -u critical -i \"$displayicon\" -t $timeout \"$phonenum - $displayname\" \"for $lineid[$count]\n$fulldate\"";
                }
                else {
                    $displayname =
"notify-send -u critical -i \"$displayicon\" -t $timeout \"$displayname\" \"$phonenum\nfor $lineid[$count]\n$fulldate\"";
                }

                # Post notification

                eval { system("$displayname") };
                warn() if $@;

                # Set flag so no multiple notifications on same call

                $flag[$count] = 1;
            }

        }
        else {
            if ( $flag[$count] == 1 ) {

                # Line is no longer ringing so reset flag

                $flag[$count] = 0;

                # Now try to write to log files if requested:

                if ($cqlog) {
                    eval { open LOG, ">> $cqlog" };
                    if ($@) {
                        Warn();
                    }
                    else {
                        eval { print LOG "$logcq[$count]$stat\"\n"; };
                        warn() if $@;
                        close LOG;
                    }
                }
                if ($plainlog) {
                    eval { open LOG, ">> $plainlog" };
                    if ($@) {
                        Warn();
                    }
                    else {
                        $stat =~ s/Idle/Not Answered/;
                        eval { print LOG "$logp[$count]$stat\)\n"; };
                        warn() if $@;
                        close LOG;
                    }
                }
            }
        }
        $count++;
    }
}
